package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.constraint.Constraint;
import easik.sketch.constraint.ProductConstraint;
import easik.sketch.constraint.SumConstraint;
import easik.sketch.path.SketchPath;
import easik.states.AddCommutativeDiagramState;
import easik.states.AddPathToConstraintState;

/**
 * Show constraint menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-17 Kevin Green
 * @version 2006-08-17 Kevin Green
 */
public class AddPathAction extends AbstractAction {	
	
	/**
	 *	Set up the add path menu option.
	 */
	public AddPathAction() {
		super("Add Path to Constraint");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Adds a path to the currently selected constraint.");		
	}
	
	/**
	 * Pushes the add path state
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		//Selection is a constraint
		if(curSelected instanceof SumConstraint){
			Constraint curConstraint = (Constraint) curSelected;
			Easik.getInstance().getStateManager().pushState(
					new AddPathToConstraintState(Easik.getInstance().getFrame().getSketch(), (ArrayList)curConstraint.getPaths().clone(), curConstraint));
		}
		else if(curSelected instanceof ProductConstraint){
			
		}
		//Selection is not a constraint
		else{ 
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
					"You don't have a sum or product constraint selected. \nPlease select a sum or product constraint and try again.",
					"No Constraint Selected", JOptionPane.ERROR_MESSAGE);
		}
	}
}